{*******************************************************}
{                                                       }
{       Turbo Pascal Runtime Library                    }
{       CRTx Interface Unit                             }
{                                                       }
{       Copyright (C) 1988,92 Borland International     }
{                                                       }
{*******************************************************}

{$i MODIF.INC}
{$define ScanBreak}
unit CrtX;

{$R-} { tady pak bude - }
{$S-}
{$I-}
{$V-}   {$D+}

interface
uses {$ifdef DPMI}DPMI,{$endif}dos;

const

{ CRT modes }

  BW40          = 0;            { 40x25 B/W on Color Adapter }
  CO40          = 1;            { 40x25 Color on Color Adapter }
  BW80          = 2;            { 80x25 B/W on Color Adapter }
  CO80          = 3;            { 80x25 Color on Color Adapter }
  CO132		= 28;           { 132x25 Color on Color Adapter }
  Mono          = 7;            { 80x25 on Monochrome Adapter }
  Font8x8       = 256;          { Add-in for ROM font }

{ Mode constants for 3.0 compatibility }

  C40           = CO40;
  C80           = CO80;

{ Foreground and background color constants }
  Black         = 0;
  Blue          = 1;
  Green         = 2;
  Cyan          = 3;
  Red           = 4;
  Magenta       = 5;
  Brown         = 6;
  LightGray     = 7;

{ Foreground color constants }
  DarkGray      = 8;
  LightBlue     = 9;
  LightGreen    = 10;
  LightCyan     = 11;
  LightRed      = 12;
  LightMagenta  = 13;
  Yellow        = 14;
  White         = 15;

{ Add-in for blinking }
  Blink         = 128;

var  { Interface variables }
  CheckBreak: Boolean;    { Enable Ctrl-Break }
  CheckEOF: Boolean;      { Enable Ctrl-Z }
  DirectVideo: Boolean;   { Enable direct video addressing }
  CheckSnow: Boolean;     { Enable snow filtering }
  LastMode: Word;         { Current text mode }
  TextAttr: Byte;         { Current text attribute }
  NormAttr: Byte;         { Saved TextAttr }
  WindMin: Word;          { Window upper left coordinates }
  WindMax: Word;          { Window lower right coordinates }
  CurCrtSize:Word;	  { Maxime Window coordinates}
{ Interface procedures }

Function KeyPressed:Boolean;	{ Return true if key is available }
Function ReadKey:char;		{ Read character from keyboard }
procedure Delay(MS: Word);
procedure Sound(Hz: Word);
procedure NoSound;

Procedure ClrScr;		{ Clear screen }
Procedure ClrEol;		{ Clear to end-of-line }
Procedure DelLine;
Procedure GotoXY(xPos:Byte;yPos:Byte);{ Position cursor }
Function WhereX:Byte; 		{ Return cursor X coordinate }
Function WhereY:Byte; 		{ Return cursor Y coordinate }
Procedure Window(x1,y1,x2,y2:Byte);{ Define output window }
Procedure WindowAll;		{ Define full output window }

Procedure TextMode(mode:Word);  { Set CRT text mode }
Procedure TextColor(Color:Byte);{ Set text color (color modes) }
Procedure TextBackground(Color:Byte);{ Set text background (color modes) }
Procedure LowVideo; 		{ Select low intensity }
Procedure HighVideo;		{ Select high intensity }
Procedure NormVideo;		{ Select normal intensity }

Procedure AssignCrt(var F:Text);{ Assign CRT to textfile }
Procedure AssignThis(var F:Text);{ Assign CRT to textfile }
Procedure AssignDosCrt;		{ set I/O chanells to special }
Procedure AssignNormal;		{ standard I/O chanells }
Procedure CrtSetup;		{ Setup CRT variables according to selected mode }
Procedure CrtReturn(var F:Textrec);{ CRT file no Op procedure }

{$ifdef ScanBreak}
var CrtBreak:Procedure;
    BreakFlag:Byte;

Procedure BreakCheck;
{$endif}
	{ Dopsane Procedury a funkce do CRT }
Function GetScrPos(x,y:Byte):Pointer;
Procedure ActiveCursor;
Procedure PasiveCursor;

const Wind:Procedure(x1,y1,x2,y2:Byte)=Window;
var ThisOpen:Pointer;
implementation
const Cursor:Word=$0000;
      ExpandChr:Byte=0;

{ ASCII equates }
const
 clr	=	$03;
 bell	=	$07;
 bs	=	$08;
 tab	=	$09;
 lf	=	$0A;
 cr	=	$0D;
 eof	=	$1A;
 esc	=	$1B;
 del	=	$7F;

var ScanCode:Byte;
    OldOpen:Pointer;
    SetCursor,GetCursor:Procedure;


const  {; File record layout}
	fHandle	= 0;
	fMode	= 2;
	fBufSize= 4;
	fPrivate= 6;
	fBufPos	= 8;
	fBufEnd	= 10;
	fBufPtr	= 12;
	fOpenProc = 16;
	fInOutProc= 20;
	fFlushProc= 24;
	fCloseProc= 28;
	fUserData = 32;
	fName	  = 48;
	fBuffer	  = 128;
	fRecSize  = 256;

	x  = 0;
	y  = 1;



Procedure CrtSetup; assembler;{ Setup CRT variables according to selected mode }
asm
        PUSH	BP
	MOV	AH,0FH
	INT	10h
	PUSH	AX
	MOV	AX,1130H
	MOV	BH,0
	MOV	DL,0
	INT	10h
	POP	AX
	MOV	CL,0
	OR	DL,DL
	JNE	@@1
	MOV	DL,24
	CMP	AL,3
	JA	@@1
	MOV	CL,1
@@1:	MOV	DH,DL
	MOV	DL,AH
	DEC	DL
	MOV	AH,0
	CMP	DH,24
	JBE	@@2
	MOV	AH,1
@@2:	MOV	LastMode,AX
	MOV	CurCrtSize,DX
	MOV	CheckSnow,CL
	MOV	DirectVideo,1
	XOR	AX,AX
	MOV	WindMin,AX
	MOV	WindMax,DX
        POP	BP
end;
{$f+}
Procedure SetCursor_active;  assembler;   { Set cursor position }
asm                           { In	DX = Cursor position }
	MOV	Cursor,DX
	MOV	AH,2
	XOR	BH,BH
	INT	10h
end;

Procedure GetCursor_active;  assembler;  { Get cursor position }
asm                           { Out	DX = Cursor position }
	MOV	AH,3
	XOR	BH,BH
	INT	10h
        MOV	Cursor,DX
end;

Procedure SetCursor_pasive;  assembler;   { Set cursor position }
asm
	MOV	Cursor,DX
end;

Procedure GetCursor_pasive;  assembler;  { Get cursor position }
{ Out	DX = Cursor position }
asm
	MOV	DX,Cursor
end;
{$f-}
Procedure PasiveCursor;
begin
 GetCursor:=GetCursor_pasive;
 SetCursor:=SetCursor_pasive;
end;
Procedure ActiveCursor;
begin
 GetCursor:=GetCursor_active;
 SetCursor:=SetCursor_active;
end;

Procedure ClrScr;  assembler; { Clear screen }
asm
	MOV	AX,6*256
	MOV	BH,TextAttr
	MOV	CX,WindMin
	MOV	DX,WindMax
	INT	10h
	MOV	DX,WindMin
	CALL	SetCursor
end;

Procedure ClrEol;  assembler; { Clear to end-of-line }
asm
	CALL	GetCursor
	MOV	AX,6*256
	MOV	BH,TextAttr
	MOV	CX,DX
	MOV	DL,byte ptr WindMax.X
	INT	10h
end;

Function WhereX:Byte; assembler; { Return cursor X coordinate }
asm
	CALL	GetCursor
	MOV	AL,DL

	SUB	AL,byte ptr WindMin.X
	INC	AL
end;

Function WhereY:Byte; assembler; { Return cursor Y coordinate }
asm
	CALL	GetCursor
	MOV	AL,DH
	SUB	AL,byte ptr WindMin.Y
	INC	AL
end;

Procedure DelLine; assembler;
asm
	MOV	AX,6*256+1

	PUSH	AX
	CALL	GetCursor
	POP	AX
	MOV	BH,TextAttr
	MOV	CL,byte ptr WindMin
	MOV	CH,DH
	MOV	DX,WindMax
	CMP	CH,DH
	JNE	@@1
	XOR	AL,AL
@@1:	int	10h
	RETF
end;

Procedure GotoXY(xPos:Byte;yPos:Byte);  assembler; { Position cursor }
asm
	MOV	DL,SS:[BP+8]
	MOV	DH,SS:[BP+6]
	DEC	DL
	ADD	DL,byte ptr WindMin.X
	JC	@@1
	CMP	DL,byte ptr WindMax.X
	JA	@@1
	DEC	DH
	ADD	DH,byte ptr WindMin.Y
	JC	@@1
	CMP	DH,byte ptr WindMax.Y
	JA	@@1
	CALL	SetCursor
@@1:
end;

Procedure TextMode(mode:Word);  assembler;  { Set CRT text mode }
asm
	MOV	AX,SS:[BP+6]
        XOR	BX,BX
        INT	10h
	CALL	CrtSetup
	MOV	AL,NormAttr
	MOV	TextAttr,AL
end;

Procedure Window(x1,y1,x2,y2:Byte); assembler; { Define output window }
asm
	MOV	DL,SS:[BP+12]
	MOV	DH,SS:[BP+10]
	MOV	CL,SS:[BP+8]
	MOV	CH,SS:[BP+6]
	CMP	DL,CL
	JA	@@1
	CMP	DH,CH
	JA	@@1
	DEC	DL
	JS	@@1
	DEC	DH
	JS	@@1
	DEC	CL
	CMP	CL,byte ptr CurCrtSize.X
	JA	@@1
	DEC	CH
	CMP	CH,byte ptr CurCrtSize.Y
	JA	@@1
	MOV	WindMin,DX
	MOV	WindMax,CX
	CALL	SetCursor
@@1:
end;

Procedure WindowAll; assembler;	{ Define full output window }
asm
        MOV	BX,1
        PUSH	BX
        PUSH	BX
	MOV	AX,CurCrtSize;
        ADD	AX,0101h
	MOV	BL,AL
	PUSH	BX
        MOV	BL,AH
	PUSH	BX
	CALL	Window;
end;

procedure Sound(Hz: Word); assembler;  {Start sound generator}
asm
	MOV	BX,Hz
	MOV	AX,34DDH
	MOV	DX,0012H
	CMP	DX,BX
	JNC	@@2
	DIV	BX
	MOV	BX,AX
	IN	AL,61H
	TEST	AL,3
	JNZ	@@1
	OR	AL,3
	OUT	61H,AL
	MOV	AL,0B6H
	OUT	43H,AL
@@1:	MOV	AL,BL
	OUT	42H,AL
	MOV	AL,BH
	OUT	42H,AL
@@2:
end;

procedure NoSound; assembler; {Turn off sound generator}
asm
	IN	AL,61H
	AND	AL,0FCH
	OUT	61H,AL
end;


Function ReadKey:char; assembler; { Read character from keyboard }
asm
	MOV	AL,ScanCode
	MOV	ScanCode,0
	OR	AL,AL
	JNE	@@1
	XOR	AH,AH
	INT	16H
	OR	AL,AL
	JNE	@@1
	MOV	ScanCode,AH
	OR	AH,AH
	JNE	@@1
	MOV	AL,'C'-64	{ Out	AL = Character }
@@1:{$ifdef ScanBreak}CALL	BreakCheck {$endif}
end;

Function KeyPressed:Boolean; assembler; { Return true if key is available }
asm
	CMP	ScanCode,0
	JNE	@@1
	MOV	AH,1
	INT	16H
	MOV	AL,0
	JE	@@2
@@1:	MOV	AL,1
@@2:
end;

procedure Delay(Ms: Word); assembler; {Delay specified number of milliseconds}
asm
	PUSH	ES
        MOV	AX,1000
        MUL	Ms
	MOV	CX,DX
        MOV	DX,AX    { pocet uS v CX:DX }

        MOV	AH,86H
        INT	15H
        POP	ES
end;

Procedure TextColor(Color:Byte); assembler; { Set text color (color modes) }
asm
	MOV	AL,Color
	TEST	AL,0F0H
	JE	@@1
	AND	AL,0FH
	OR	AL,80H
@@1:	AND	TextAttr,70H
	OR	TextAttr,AL
end;

Procedure TextBackground(Color:Byte); assembler; { Set text background (color modes) }
asm
	MOV	AL,Color
	AND	AL,7
	MOV	CL,4
	SHL	AL,CL
	AND	TextAttr,8FH
	OR	TextAttr,AL
end;

Procedure LowVideo; assembler;		{ Select low intensity }
asm
	AND	TextAttr,0F7H
end;

Procedure HighVideo; assembler;		{ Select high intensity }
asm
	OR	TextAttr,8
end;

Procedure NormVideo; assembler;		{ Select normal intensity }
asm
	MOV	AL,NormAttr
	MOV	TextAttr,AL
end;

{ operace s kanaly - presmerovani ..... }


Procedure LineFeed; assembler; { Do line-feed operation }
{ In	DX = Cursor position }
asm
	INC	DH
	CMP	DH,byte ptr WindMax.Y
	JBE	@@1
	DEC	DH
	PUSH	CX
	PUSH	DX
	MOV	AX,6*256+1
	MOV	BH,TextAttr
	MOV	CX,WindMin
	MOV	DX,WindMax
	INT	10h
	POP	DX
	POP	CX
@@1:
end;

Procedure WriteChar; assembler;  { Write character on CRT }
{ In	AL = Character }
asm
	PUSH	BX
	PUSH	CX
	PUSH	DX
	PUSH	ES
	PUSH	AX
	CALL	GetCursor
	POP	AX
        CMP	ExpandChr,0
        JE	@@12
        MOV     TextAttr,AL
        MOV	ExpandChr,0
        JMP	@@5

@@12:	CMP	AL,clr	{Zmena barvy}
	JNE	@@10
	MOV	ExpandChr,1
        JMP	@@5

@@10:	CMP	AL,bell
	JNE	@@1
        MOV	AH,14    { pipnuti }
	INT	10h
	JMP	@@5

@@1:	CMP	AL,bs
	JNE	@@2
        CMP	DL,byte ptr WindMin.X
	JE	@@5
	DEC	DL
	JMP	@@5

@@2:	CMP	AL,cr
	JNE	@@3
        MOV	DL,byte ptr WindMin.X
	JMP	@@5

@@3:	CMP	AL,lf
	JE	@@4
@@6:    CMP	AL,tab	;{osetreni tebelatoru- jeho delka je 8}
	JNE	@@7
        MOV	AL,DL
        ADD	AL,8
        AND	AL,11111000b
        JMP	@@8

@@7:	MOV	AH,9
	MOV	BL,TextAttr
	XOR	BH,BH
	MOV	CX,1
	PUSH	DX
	INT	10h
	POP	DX
	INC	DL
@@8:	CMP	DL,byte ptr WindMax.X
	JBE	@@5
	MOV	DL,byte ptr WindMin.X

@@4:	CALL	LineFeed
@@5:	CALL	SetCursor
	POP	ES
	POP	DX
	POP	CX
	POP	BX
end;

Procedure CrtRead(var F:Textrec); far; assembler;	{ CRT file read procedure }
asm
        LES	DI,SS:[BP+6]
	MOV	DX,ES:[DI].fBufSize
	DEC	DX
	DEC	DX
	MOV	SI,ES:[DI].fBufPos
	LES	DI,ES:[DI].fBufPtr
	XOR	BX,BX
@@1:	MOV	ScanCode,0
	CALL	ReadKey
	MOV	CX,1
	CMP	AL,bs
	JE	@@2
	CMP	AL,'S'-64
	JE	@@2
	CMP	AL,'D'-64
	JE	@@3
	DEC	CX
	CMP	AL,esc
	JE	@@2
	CMP	AL,'A'-64
	JE	@@2
	CMP	AL,'F'-64
	JE	@@3
	CMP	AL,eof
	JE	@@4
	CMP	AL,cr
	JE	@@5
	CMP	AL,' '
	JB	@@1
	CMP	BX,DX
	JE	@@1
	MOV	ES:[DI+BX],AL
	INC	BX
	CALL	WriteChar
	CMP	BX,SI
	JBE	@@1
	MOV	SI,BX
	JMP	@@1
@@2:	OR	BX,BX
	JE	@@1
	MOV	AL,bs
	CALL	WriteChar
	MOV	AL,' '
	CALL	WriteChar
	MOV	AL,bs
	CALL	WriteChar
	DEC	BX
	LOOP	@@2
	JMP	@@1
@@3:	CMP	BX,SI
	JE	@@1
	MOV	AL,ES:[DI+BX]
	CMP	AL,' '
	JB	@@1
	CALL	WriteChar
	INC	BX
	LOOP	@@3
	JMP	@@1
@@4:	CMP	CheckEOF,0
	JE	@@1
	MOV	ES:[DI+BX],AL
	INC	BX
	JMP	@@6
@@5:	MOV	AL,cr
	CALL	WriteChar
        MOV	AL,lf
	CALL	WriteChar
	MOV	WORD PTR ES:[DI+BX],cr+lf*256
	INC	BX
	INC	BX
@@6:	LES	DI,SS:[BP+6]
	XOR	AX,AX
	MOV	ES:[DI].fBufPos,AX
	MOV	ES:[DI].fBufEnd,BX
end;

Procedure CrtWrite(var F:Textrec); far; assembler;	{ CRT file write procedure }
asm
	PUSH	DS
	LES	DI,SS:[BP+6]
	MOV	CX,ES:[DI].fBufPos
	SUB	ES:[DI].fBufPos,CX
	JCXZ	@@15                 { nic tam neni }
        LES	DI,ES:[DI].fBufPtr
        CMP	DirectVideo,1
        JE	@@2
@@1:	MOV	AL,ES:[DI]
        CALL	WriteChar
	INC	DI
	LOOP	@@1
@@15:	JMP	@@4

@@2:    PUSH	CX
	CALL	GetCursor
@@7:	PUSH	DX
        XOR	AH,AH
        MOV	AL,DL
        INC	AX
        PUSH	AX
        MOV	AL,DH
        INC	AX
        PUSH	AX
        CALL	GetScrPos
        MOV	BH,TextAttr
        MOV	BL,byte ptr WindMax.X
        MOV	SI,AX
        MOV	AX,DX
        MOV	DS,AX	;{obrazovka je v DS:SI - zmena DS!!}
        MOV	AH,BH	{TextAttr}
        POP	DX
        POP	CX
@@3:	MOV	AL,ES:[DI]
	INC	DI
	CMP	AL,cr		{nejvetsi ridici znak}
        JA	@@13
        JNE	@@9
        POP	DS
        PUSH	DS
	MOV	DL,byte ptr WindMin.X
        JMP	@@12

@@9:	CMP	AL,lf
        JNE	@@10
        POP	DS
        PUSH	DS
        JMP	@@11

@@10:   CMP	AL,clr
	JNE	@@16
        POP	DS
        PUSH	DS
        MOV	AL,ES:[DI]
	INC	DI
        MOV	TextAttr,AL
        LOOP	@@12
        JMP	@@8

@@16:	CMP	AL,tab
	JNE	@@13
        MOV	AL,DL
        INC	AL
        AND	AL,0111b
        MOV	AL,' '
        JZ	@@13
        DEC	DI		;{pridej dalsi mezeru pro tabulator}
        INC	CX

@@13:	MOV	DS:[SI],AX
        ADD	SI,2
        INC	DL
@@14:	CMP	DL,BL
	JBE	@@5
	POP	DS		;{puvodni DS}
        PUSH	DS
        MOV	DL,byte ptr WindMin.X
@@11:	CALL	LineFeed
@@12:	DEC	CX
        JCXZ	@@8	;{Konec Textu?}
	PUSH    CX
        JMP	@@7
@@5:	LOOP	@@3
	POP	DS
        PUSH	DS
@@8:	CALL	SetCursor
@@4:    POP	DS
	{$ifdef ScanBreak}CALL	BreakCheck {$endif}
	XOR	AX,AX
end;

{$f+}
Procedure CrtReturn(var F:Textrec); assembler; 	{ CRT file no Op procedure }
asm
	XOR	AX,AX
end;
{$f-}

Procedure CrtOpen(var F:Textrec); far; assembler;  { CRT file open procedure }
asm
	PUSH	DS
	LDS	DI,SS:[BP+6]
	MOV	AX,OFFSET CrtRead
	MOV	BX,OFFSET CrtReturn
	MOV	CX,BX
	CMP	word ptr [DI].fMode,fmInput
	JE	@@1
	MOV	word ptr [DI].fMode,fmOutput
	MOV	AX,OFFSET CrtWrite
	MOV	BX,AX
@@1:	MOV	[DI].(fInOutProc+0),AX
	MOV	[DI].(fInOutProc+2),CS
	MOV	[DI].(fFlushProc+0),BX
	MOV	[DI].(fFlushProc+2),CS
	MOV	[DI].(fCloseProc+0),CX
	MOV	[DI].(fCloseProc+2),CS
	XOR	AX,AX
	POP	DS
end;

Procedure AssignThis(var F:Text); assembler;   { Assign CRT to textfile }
asm
	PUSH	DS
	LDS	DI,SS:[BP+6]
	MOV	word ptr [DI].fMode,fmClosed
	MOV	word ptr [DI].fBufSize,128
	LEA	AX,word ptr [DI].fBuffer
	MOV	[DI].(fBufPtr+0),AX           { ofs }
	MOV	[DI].(fBufPtr+2),DS           { seg }
        MOV	AX,word ptr ThisOpen
	MOV	word ptr [DI].(fOpenProc+0),AX
	MOV	AX,word ptr ThisOpen+2
	MOV	word ptr [DI].(fOpenProc+2),AX
	MOV	word ptr [DI].fName,0
	POP	DS
end;

Procedure AssignInputOutput;
begin
 AssignThis(Input);
 Reset(Input);
 AssignThis(Output);
 Rewrite(Output);
end;

Procedure AssignDosCrt;   assembler;
asm
	MOV	AX,offset CrtOpen { standardni inicializacni procedura }
	MOV	word ptr ThisOpen,AX
	MOV	AX,CS
	MOV	word ptr ThisOpen+2,AX
        CALL    AssignInputOutput
end;

Procedure AssignCrt(var F:Text);   assembler;
asm
	MOV	AX,offset CrtOpen { standardni inicializacni procedura }
	MOV	word ptr ThisOpen,AX
	MOV	AX,CS
	MOV	word ptr ThisOpen+2,AX
        MOV	AX,ss:[BP+8]
        PUSH	AX
        MOV	AX,ss:[BP+6]
        PUSH	AX
        CALL    AssignThis
end;

Procedure AssignNormal;
begin
 ThisOpen:=OldOpen; { standardni inicializacni procedura }
 AssignInputOutput;
end;

Function GetScrPos(x,y:Byte):Pointer ;assembler;
asm
	MOV	CL,x     { Predane parametry pozice kurzoru }
        DEC	CL
        MOV	CH,y
        DEC	CH

	PUSH	DS
	MOV	DS,Seg0040
	MOV	AL,CH
        MOV	AH,0
	MUL	WORD PTR DS:4Ah	   { CrtWidth }
	XOR	CH,CH
	ADD	AX,CX
	SHL	AX,1
	CMP	BYTE PTR DS:49h,7  { CrtMode }
        POP	DS		   { puvodni hodnota do DS }

	MOV	DX,SegB800
	JNE	@@1
	MOV	DX,SegB000
@@1:	                           { ukazatel se vraci v DX:AX }
end;

{$ifdef ScanBreak}
{$ifdef DPMI}
Procedure BreakHandler; assembler;
asm                 	;{Ctrl-Break interrupt handler}
	MOV	ES:BreakFlag,1
	CLD
	LODSW
	MOV	ES:[DI].Registers386.&IP,AX
	LODSW
	MOV	ES:[DI].Registers386.&CS,AX
	LODSW
	MOV	ES:[DI].Registers386.Flags,AX
	ADD	ES:[DI].Registers386.&SP,6
	iret
end;
{$else}
Procedure BreakHandler; interrupt; assembler;
asm                 	;{Ctrl-Break interrupt handler}
	MOV	BreakFlag,1
end;
{$endif}

procedure CrtStdBreak; far; assembler;
asm
	MOV	AL,'^'
	CALL	WriteChar
	MOV	AL,'C'
	CALL	WriteChar
{	CALL	WriteCrLf}
	MOV	AX,4CFFh	{ukonceni procesu}
	INT	21h
end;

Procedure BreakCheck; assembler;
asm
	CMP	BreakFlag,0
	JNE	@@1
@@0:	RET
@@1:    CMP	CheckBreak,0
	JE	@@0

	MOV	BreakFlag,0
@@2:	MOV	AH,1
	INT	16H
	JE	@@3
	MOV	AH,0
	INT	16H
	JMP	@@2
@@3:    CALL	CrtBreak
end;
{$endif}

{$ifdef CrtX}
begin
ActiveCursor;
CrtSetup;
 asm
	MOV	AH,8
	XOR	BH,BH
	INT	10h		{ precti znak a atribut }
	MOV	AL,AH
	AND	AL,7FH
	MOV	NormAttr,AL
	MOV	TextAttr,AL
        XOR	AX,AX
	MOV	CheckEOF,AL
	MOV	ScanCode,AL
	MOV	BreakFlag,AL
	INC	AX
	MOV	CheckBreak,AL

        MOV	AX,seg Output { prekopiruje standardni procedury vystupu }
        MOV	ES,AX
        MOV	DI,offset Output.fOpenProc
        MOV	AX,word ptr ES:DI
        MOV	word ptr OldOpen,AX
        MOV	AX,word ptr ES:DI+2
        MOV	word ptr OldOpen+2,AX
 end;
{$ifdef ScanBreak}
CrtBreak:=CrtStdBreak;
{$ifdef DPMI}SetIntVec_CB{$else}SetIntVec{$endif}($1B,@BreakHandler);
{$endif}
AssignDosCrt;	{ presmeruje vstupni a vystupni kanaly }
{$endif}
end.